--------------------------------------------------------------------------------
LIBRARY IEEE;
USE IEEE.Std_Logic_1164.all;
USE IEEE.Std_Logic_Unsigned.all;
--------------------------------------------------------------------------------

--------------------------------------------------------------------------------
ENTITY Configurable_U30 IS
  PORT(
      CI   : IN std_logic := 'U';
      A    : IN std_logic_vector(3 downto 0) :=(OTHERS => 'U');
      B    : IN std_logic_vector(3 downto 0) :=(OTHERS => 'U');
      S    : OUT std_logic_vector(3 downto 0) :=(OTHERS => '0')
  );
END Configurable_U30;
--------------------------------------------------------------------------------

--------------------------------------------------------------------------------
ARCHITECTURE structure OF Configurable_U30 IS
--------------------------------------------------------------------------------
SIGNAL SA : std_logic_vector(4 downto 0);
SIGNAL SB : std_logic_vector(4 downto 0);
--------------------------------------------------------------------------------
BEGIN
    SA(3 downto 0) <= A;
    SA(4) <= '0';
    SB(3 downto 0) <= B;
    SB(4) <= '0';
    PROCESS(SA, SB, CI)
    VARIABLE SS : std_logic_vector(4 downto 0);
    BEGIN
        SS := SA + SB + CI;
        S(3 downto 0) <= SS(3 downto 0);
    END PROCESS;
END structure;
--------------------------------------------------------------------------------
